/*
 * Decompiled with CFR 0.152.
 */
package wafflestomper.ghostwriter.gui.widget;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wafflestomper.ghostwriter.gui.screen.GhostwriterFileBrowserScreen;

public class FileSelectionList
extends ObjectSelectionList<Entry> {
    private final ParentDirEntry parentDir;
    private final List<PathItemEntry> fileList = Lists.newArrayList();
    private final GhostwriterFileBrowserScreen owner;

    public FileSelectionList(GhostwriterFileBrowserScreen ownerIn, Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.owner = ownerIn;
        this.parentDir = new ParentDirEntry(this.owner);
    }

    public void updateFileList(List<File> displayFiles) {
        this.fileList.clear();
        for (File f : displayFiles) {
            this.fileList.add(new PathItemEntry(this.owner, f));
        }
        this.m_93516_();
        this.m_7085_((AbstractSelectionList.Entry)this.parentDir);
        for (PathItemEntry n : this.fileList) {
            this.m_7085_((AbstractSelectionList.Entry)n);
        }
    }

    public static class ParentDirEntry
    extends Entry {
        protected final GhostwriterFileBrowserScreen owner;
        protected final Minecraft mc;
        protected long lastClickTime = 0L;

        public ParentDirEntry(GhostwriterFileBrowserScreen ownerIn) {
            this.owner = ownerIn;
            this.mc = Minecraft.m_91087_();
        }

        @ParametersAreNonnullByDefault
        public void m_6311_(GuiGraphics guiGraphics, int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean mouseIsOver, float p_render_9_) {
            guiGraphics.m_280488_(this.mc.f_91062_, "..", p_render_3_, p_render_2_ + 1, 65280);
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.owner.setSelectedSlot(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.lastClickTime = 0L;
                this.owner.navigateUp();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public Component m_142172_() {
            return Component.m_237115_((String)"NOT_SET - please file an issue in the Ghostwriter Github repo");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PathItemEntry
    extends Entry {
        public final File path;
        protected final GhostwriterFileBrowserScreen owner;
        protected final Minecraft mc;
        protected long lastClickTime;
        private long hoverStart = System.currentTimeMillis();

        public PathItemEntry(GhostwriterFileBrowserScreen ownerIn, File pathIn) {
            this.path = pathIn;
            this.owner = ownerIn;
            this.mc = Minecraft.m_91087_();
        }

        @ParametersAreNonnullByDefault
        public void m_6311_(GuiGraphics guiGraphics, int p_render_1_, int p_render_2_, int slotX, int slotWidth, int p_render_5_, int mouseX, int mouseY, boolean mouseIsOver, float partialTicks) {
            int color = 0xFFFFFF;
            if (!this.path.exists()) {
                color = 0x333333;
                this.owner.setDirectoryDirty();
            } else if (this.path.isFile()) {
                color = 0xFF0000;
            } else if (this.path.isDirectory()) {
                color = 65280;
            }
            String s = this.mc.f_91062_.m_92834_(this.path.getName(), slotWidth);
            guiGraphics.m_280488_(this.mc.f_91062_, s, slotX, p_render_2_ + 1, color);
            if (mouseIsOver) {
                if (System.currentTimeMillis() - this.hoverStart > 2000L) {
                    String s2 = this.path.getName();
                    this.owner.setHoveringText(s2);
                }
            } else {
                this.hoverStart = System.currentTimeMillis();
            }
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.owner.setSelectedSlot(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.lastClickTime = 0L;
                this.owner.navigateInto(this.path);
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public Component m_142172_() {
            return Component.m_237115_((String)"NOT_SET - please file an issue in the Ghostwriter Github repo");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }
}

